︠73e82123-2dbc-4403-bcc7-6fcea05c8869s︠
f(x) = x^3 - x

f_prime(x) = diff( f(x), x)

@interact
def tangent_at_point( x_0 = slider(-2, 2, 0.1, -1.5, label="x-coordinate") ):
    y_0 = f( x_0 )
    m = f_prime( x_0 )

    # because y - y_0 = m(x - x_0) we know that
    # y - y_0 = mx - m*x_0
    # y = mx + y_0 - m*x_0
    # therefore b = y_0 - m*x_0

    b = y_0 - m*x_0

    P1 = plot( f(x), -2, 2, color='blue', ymin=-6, ymax=6, gridlines='minor')
    P2 = plot( m*x + b, -2, 2, color='tan', ymin=-6, ymax=6)
    P3 = point( (x_0, y_0), color='red', size=50)

    P = P1+P2+P3

    P.show()

    print()
    print("x_0 = ", x_0)
    print("y_0 = f(x_0) = ", y_0)
    print("m = f'(x_0) = ", m)
    print("tangent line: y = (", m, ")*x + (", b, ")")

    return

︡22dacb15-0ad1-4242-baa7-313fe78b6e64︡{"interact":{"controls":[{"animate":true,"control_type":"slider","default":5,"display_value":true,"label":"x-coordinate","vals":["-2.00000000000000","-1.90000000000000","-1.80000000000000","-1.70000000000000","-1.60000000000000","-1.50000000000000","-1.40000000000000","-1.30000000000000","-1.20000000000000","-1.10000000000000","-0.999999999999999","-0.899999999999999","-0.799999999999999","-0.699999999999999","-0.599999999999999","-0.499999999999999","-0.399999999999999","-0.299999999999999","-0.199999999999999","-0.0999999999999994","6.38378239159465e-16","0.100000000000001","0.200000000000001","0.300000000000001","0.400000000000001","0.500000000000001","0.600000000000001","0.700000000000001","0.800000000000001","0.900000000000001","1.00000000000000","1.10000000000000","1.20000000000000","1.30000000000000","1.40000000000000","1.50000000000000","1.60000000000000","1.70000000000000","1.80000000000000","1.90000000000000","2.00000000000000"],"var":"x_0","width":null}],"flicker":false,"id":"012d5119-a053-4e88-bdad-4109fa05db77","layout":[[["x_0",12,null]],[["",12,null]]],"style":"None"}}︡{"done":true}
︠6b6e3b6e-96a7-4b3a-9d3a-39054d8f8878︠

︡765d65ad-6728-47c2-99d9-5e301f724dc8︡
︠279c7a78-24b7-4daa-b33f-f80b8dfbf3f8︠
︡19d89fdf-fb1e-452d-a64e-9816a8787a44︡
︠6cc4c74c-4282-467e-a71c-2ee181ad3dd6︠
︡c2303d93-1822-4b74-8954-89b90b413b95︡
︠15306028-707a-4a01-8e79-e36574674aac︠
︡26d4f361-3fb2-46a1-92b0-bbe3a59d864a︡
︠bfdf6d68-bf7f-4562-8fcd-1f38227b6749︠









